function [R, T, A] = multi_layer_TE(angle)

global lambda index nair width;

% from air to first layer

qj=nair*cos(angle);
   
qk=sqrt(index(1,:).^2-(nair.^2)*(sin(angle))^2);
rjk=(qj-qk)./(qj+qk);
tjk=2*qj./(qj+qk);
   
S(1,1,:)=1./tjk;
S(1,2,:)=rjk./tjk;
S(2,1,:)=S(1,2,:);
S(2,2,:)=S(1,1,:);
    
% all other layers
  
for j=1:length(width)
         
    qj=sqrt(index(j,:).^2-(nair.^2)*(sin(angle))^2);
    qk=sqrt(index(j+1,:).^2-(nair.^2)*(sin(angle))^2);
      
    bj=2*pi*qj./lambda;
      
    Lj(1,1,:)=exp(-i*bj.*width(j));
    Lj(1,2,:)=0;
    Lj(2,1,:)=0;
    Lj(2,2,:)=exp(i*bj.*width(j));
   
    rjk=(qj-qk)./(qj+qk);
    tjk=2*qj./(qj+qk);
        
    Ijk(1,1,:)=1./tjk;
    Ijk(1,2,:)=rjk./tjk;
    Ijk(2,1,:)=Ijk(1,2,:);
    Ijk(2,2,:)=Ijk(1,1,:);
        
    for k=1:length(lambda)
        S(:,:,k)=S(:,:,k)*Lj(:,:,k)*Ijk(:,:,k);
    end
end

R(1,:) = abs((S(2,1,:)./S(1,1,:))).^2;
T(1,:) = abs(1./S(1,1,:)).^2;
T = T.*sqrt(index(size(index,1),:).^2-(nair.^2)*(sin(angle))^2)...
    ./sqrt(nair.^2-(nair.^2)*(sin(angle))^2);

A = 1-T-R;